//
//  GSPathWatcher.h
//  GlyphsCore
//
//  Created by Georg Seifert on 13.02.22.
//  Copyright © 2022 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSPathWatcherObserver

- (void)fileForPathDidChange:(NSString *)path;

@end

@interface GSPathWatcher : NSObject

+ (void)addObserver:(NSObject <GSPathWatcherObserver> *)observer forPath:(NSString *)filePath;

+ (void)removeObserver:(NSObject *)observer forPath:(NSString *)filePath;

@end

NS_ASSUME_NONNULL_END
